﻿/*******************************************************************************
 *
 *   Nom                     : Scripts.js
 *   Type                    : Fichier de scripts javascripts utilisant JQuery
 *   Description             : Fichier de scripts de la page "Default.html"
 *
 *   Auteurs                 : Julien Dumortier et Geoffrey Walla, élèves de BTS IRIS du lycée Gustave Eiffel d'Armentières
 *   Version                 : 3.0
 *   Création                : 
 *   Dernière modification   : 15/01/13    
 *
********************************************************************************/


//Pour avoir l'intellisense
/// <reference path="jquery-1.7.1.js" />

//------------------------ Déclaration des constantes --------------------------

/* ------------ Pour le contrôle Bing Maps ------------ */
var map;                                                                           //Contient le contrôle Bing Maps
var startLoc = new Microsoft.Maps.Location(50.63600193762228, 3.0712441303364);    //Création de la localisation centrale
var startPushpin;                                                                  //punaise centrale
var layer;                                                                         //layer contenant le gabarit
var layerPushPin;                                                                  //layer contenant la punaise centrale 

/* ---------- Pour le gabarit d'hélicoptère ---------- */
var coteCarre = 12.94;                                                             //Dimension d'un coté du carré
var angle = 0;                                                                     //Angle d'incidence du gabarit (à partir de l'horizontale)
var rayonTerre = 6371000;                                                          //Rayon de la Terre (en mètres)
var divergenceNuit = 0.15;                                                         //Angle de divergence de nuit : 15%
var largeurExterieurMax = 120;                                                     //Largeur à l'extrémité du parcours
var longueurTotale = 3378;                                                         //Longueur totale trapèze + rectangle

/* ------------------ Pour la jauge ------------------ */
var canvas;                                                                         //Element "canvas" du DOM
var context;                                                                        //Context du canvas
var xCenter;                                                                        //position en X du centre du cercle par rapport à la div canvas
var yCenter;                                                                        //position en Y du centre du cercle par rapport à la div canvas
var rayon = 70;                                                                     //Rayon du cercle de la jauge
var cercle;                                                                         //Element HTML : canvas
var input;                                                                          //Element HTML : zone de texte
//-------------------- Fin de déclaration des constantes ------------------------

//------------------- Traitement logique de l'application -----------------------
$("document").ready(
    function () {

        //Affichage du contrôle Bing Maps
        map = new Microsoft.Maps.Map(document.getElementById('MapControl'), {
            credentials: 'AvSTZm3ijhtaXH2zYOCFJaPa9VVK6Tvn1t5nBxCEbfOqt3HSk0FzFfcBEGOFbKPv',  //Clef de développement Bing Maps
            enableSearchLogo: false,                                                          //Désactive le logo de recherche
            center: startLoc,                                                                 //Centre la carte
            zoom: 16,                                                                         //Régle le zoom sur la carte
            width: 600,                                                                       //Largeur du controle
            height: 550,                                                                      //Hauteur du controle
            mapTypeId: Microsoft.Maps.MapTypeId.aerial                                        //pour avoir vue "réelle" des bâtiments  
        });

        //Ajout d'une punaise simple
        function addPushpin(latitude, longitude) {
            var pushpin = new Microsoft.Maps.Pushpin(new Microsoft.Maps.Location(latitude, longitude));     //Création de la punaise
            layer.push(pushpin);                                                                            //Ajout de la punaise sur le contrôle
        }

        //Ajout d'une ligne simple
        function addPolyline(locs) {
            //Suppression de toutes les punaises et lignes
            layer.entities.clear();                                     

            //Ajout de la ligne
            var polyline = new Microsoft.Maps.Polyline(locs, null);     //Création de la ligne
            layer.push(polyline);                                       //Ajout de la ligne sur le contrôle
        }

        //Ajout d'un polygone
        function addPolygon(locs) {
            var options = { fillColor: new Microsoft.Maps.Color(0, 0, 0, 0) };  //Choix de la couleur du polygône
            var polygon = new Microsoft.Maps.Polygon(locs, options);            //Création du polygône
            layer.push(polygon);                                                //Ajout du polygône sur le layer
        }

        //Création d'un evenement sur un composant
        function addEvent(prmComposant, prmNomEv, prmFonction) {
            Microsoft.Maps.Events.addHandler(prmComposant, prmNomEv, prmFonction);  //Création d'un événement sur un composant du contrôle Bing Maps
        }

        //Création d'un layer
        function addLayer() {
            layer = new Microsoft.Maps.EntityCollection();   //Création du layer
            map.entities.push(layer);                        //Ajout du layer sur le contrôle Bing Maps
        }

        //Calcul des coordonnees à partir d'un premier point, d'une distance et d'un angle
        function calculCoords(startLoc, distance, bearing)
        {
            //Localisation du point final
            var endLatitude;
            var endLongitude;
            var endLocation;

            //Conversion des données en radians
            var radLatStart = degreeToRad(startLoc.latitude);
            var radLongStart = degreeToRad(startLoc.longitude);
            var radBearing = degreeToRad(bearing);

            //Calcul du rapport
            var rapport = distance / rayonTerre;

            //Calcul des coordonnees du point d'arrivée
            endLatitude = Math.asin(Math.sin(radLatStart) * Math.cos(rapport) + Math.cos(radLatStart) * Math.sin(rapport) * Math.cos(radBearing));

            endLongitude = radLongStart + Math.atan2(Math.sin(radBearing) * Math.sin(rapport) * Math.cos(radLatStart),
                                 Math.cos(rapport) - Math.sin(radLatStart) * Math.sin(endLatitude));
            
            //Création de la localisation finale
            endLocation = new Microsoft.Maps.Location(radToDegree(endLatitude), radToDegree(endLongitude));
           
            return endLocation;
        }

        //Converti en radians une donnée en degré
        function degreeToRad(prmDegree)
        {
            return prmDegree * (Math.PI / 180);
        }

        //Converti en degrés une donnée en radians
        function radToDegree(prmRad)
        {
            return prmRad * (180 / Math.PI);
        }

        //Calcul des localisations constituant le gabarit
        function getLocations(prmStartLocationLatitude, prmStartLocationLongitude, prmDistance, prmBearing)
        {
            //Formes constituant le gabarit
            var Carre = [];
            var Rectangle1 = [];
            var Rectangle2 = [];
            var Trapeze1 = [];
            var Trapeze2 = [];

            //Localisations du gabarit final
            var rep = [];

            //Mise en degres de l'angle de divergence
            var angleDivergence = radToDegree(Math.atan(divergenceNuit));

            //Calcul de la longueur des 2 rectangles
            var d = ((largeurExterieurMax - prmDistance) / 2) / Math.sin(angleDivergence);
            var distanceRestante = longueurTotale - d * Math.cos(Math.atan(divergenceNuit));

            //Calcul des coordonnées des sommets du carré
            for (var i = 0; i < 4; i++)
            {
                var currentLoc = new Microsoft.Maps.Location(prmStartLocationLatitude, prmStartLocationLongitude);
                Carre.push(calculCoords(currentLoc, prmDistance, prmBearing + 45 + 90 * i));
            }

            //Calcul des coordonnées des sommets du premier trapeze
            Trapeze1.push(Carre[0]);
            Trapeze1.push(calculCoords(Carre[0], d, prmBearing + 90 - angleDivergence));
            Trapeze1.push(calculCoords(Carre[1], d, prmBearing + 90 + angleDivergence));
            Trapeze1.push(Carre[1]);
            
            //Calcul des coordonnées des sommets du deuxième trapeze
            Trapeze2.push(Carre[2]);
            Trapeze2.push(calculCoords(Carre[2], d, prmBearing + 270 - angleDivergence));
            Trapeze2.push(calculCoords(Carre[3], d, prmBearing + 270 + angleDivergence));
            Trapeze2.push(Carre[3]);

            //Calcul des coordonnées des sommets du premier rectangle
            Rectangle1.push(Trapeze1[1]);
            Rectangle1.push(calculCoords(Trapeze1[1], distanceRestante, prmBearing + 90));
            Rectangle1.push(calculCoords(Trapeze1[2], distanceRestante, prmBearing + 90));
            Rectangle1.push(Trapeze1[2]);

            //Calcul des coordonnées du des sommets deuxième rectangle
            Rectangle2.push(Trapeze2[1]);
            Rectangle2.push(calculCoords(Trapeze2[1], distanceRestante, prmBearing + 270));
            Rectangle2.push(calculCoords(Trapeze2[2], distanceRestante, prmBearing + 270));
            Rectangle2.push(Trapeze2[2]);

            //Construction de la reponse 
            rep.push(Carre);
            rep.push(Trapeze1);
            rep.push(Trapeze2);
            rep.push(Rectangle1);
            rep.push(Rectangle2);

            return rep;
        }

        //Tracé du gabarit
        function getGabarit(prmStartLat, prmStartLong, prmDistance, prmBearing) {

            //Suppression de l'ancien gabarit
            layer.clear();

            //affichage de la trajectoire correspondant au bateau indiqué
            var locs = [];

            var resultat = getLocations(prmStartLat, prmStartLong, prmDistance, prmBearing);

            //Affichage du carre ----------------------------------------------------------
            //On remplie un tableau de "location" avec les valeurs récupérées depuis le service web
            for (var i = 0; i < resultat[0].length; i++) {
                locs.push(new Microsoft.Maps.Location(resultat[0][i].latitude, resultat[0][i].longitude));
            }

            locs.push(new Microsoft.Maps.Location(resultat[0][0].latitude, resultat[0][0].longitude));

            //Ajout de la ligne
            addPolygon(locs);
            locs = [];

            //Ajout du trapeze 1 ----------------------------------------------------------------
            //On remplie un tableau de "location" avec les valeurs récupérées depuis le service web
            for (var i = 0; i < resultat[1].length; i++) {
                locs.push(new Microsoft.Maps.Location(resultat[1][i].latitude, resultat[1][i].longitude));
            }

            //Ajout de la ligne
            addPolygon(locs);
            locs = [];

            //Ajout du trapeze 2 ----------------------------------------------------------------
            //On remplie un tableau de "location" avec les valeurs récupérées depuis le service web
            for (var i = 0; i < resultat[2].length; i++) {
                locs.push(new Microsoft.Maps.Location(resultat[2][i].latitude, resultat[2][i].longitude));
            }

            //Ajout de la ligne
            addPolygon(locs);
            locs = [];

            //Ajout du Rectangle 1 ----------------------------------------------------------------
            //On remplie un tableau de "location" avec les valeurs récupérées depuis le service web
            for (var i = 0; i < resultat[3].length; i++) {
                locs.push(new Microsoft.Maps.Location(resultat[3][i].latitude, resultat[3][i].longitude));
            }

            //Ajout de la ligne
            addPolygon(locs);
            locs = [];

            //Ajout du Rectangle 2 ----------------------------------------------------------------
            //On remplit un tableau de "Location" avec les valeurs récupérées depuis le service web
            for (var i = 0; i < resultat[4].length; i++) {
                locs.push(new Microsoft.Maps.Location(resultat[4][i].latitude, resultat[4][i].longitude));
            }

            //Ajout de la ligne
            addPolygon(locs);
            locs = [];
        }
        
        //Fonction utilisé lors du drag du pushpin central
        var dragCouloir = function (e) {
            //Tracé du gabarit
            getGabarit(e.entity.getLocation().latitude, e.entity.getLocation().longitude, coteCarre, angle);
        }

        //Ajout du layer sur le contrôle
        addLayer();

        //Création de la pushpin
        startPushpin = new Microsoft.Maps.Pushpin(startLoc, { draggable: true });

        //Ajout de l'événement "drag" sur la punaise centrale
        addEvent(startPushpin, 'drag', dragCouloir);

        //Ajout de la pushpin centrale
        layerPushPin = new Microsoft.Maps.EntityCollection();
        layerPushPin.push(startPushpin);
        map.entities.push(layerPushPin);

        //Tracé du gabarit
        getGabarit(startLoc.latitude, startLoc.longitude, coteCarre, angle);

        //---------------------------------------------------------------------------------
        //------------------------------ Configuration -------------------------------------
        //---------------------------------------------------------------------------------

        /*-----------------  Choix de l'appareil -----------------*/
        //appareil précédemment sélectionné
        var dernierAppareil = $('name=radioGroupeAppareil:checked');

        //on associe l'événement onChange sur le groupe de boutons radios
        var radiosAppareil = $('[name=radioGroupeAppareil]').bind('change', function (ev) {
            var clickedAppareil = $(ev.target);                                 //Récuperation du nouvel element selectionne
            dernierAppareil.trigger('unclick');                         //Déselection de l'appareil sélectionné précédemment
            dernierAppareil = $('[name=radioGroupeAppareil]:checked');  //Selection du nouvel appareil

            //Choix du cote du carré selon les modèles
            switch (clickedAppareil.attr('value'))
            {
                case 'Ecureuil':
                    coteCarre = 12.94;
                    break;
                case 'Dauphin':
                    coteCarre = 13.68;
                    break;
                case 'DauphinN4':
                    coteCarre = 14.3;
                    break;
                case 'MD900':
                    coteCarre = 11.84;
                    break;
                case 'MD902':
                    coteCarre = 11.84;
                    break;
            }
            //Calcul du nouveau gabarit avec les nouvelles données
            getGabarit(startPushpin.getLocation().latitude, startPushpin.getLocation().longitude, coteCarre, angle);
        });

        /*-----------------  Choix de la performance -----------------*/
        //Performance précédemment sélectionné
        var dernierePerf = $('name=radioGroupePerf:checked');

        //on associe l'événement onChange sur le groupe de boutons radios
        var radiosPerf = $('[name=radioGroupePerf]').bind('change', function (ev) {
            var clickedPerf = $(ev.target);                                 //Récuperation du nouvel element selectionne
            dernierePerf.trigger('unclick');                                //Déselection de la performance sélectionnée précédemment
            dernierePerf = $('[name=radioGroupePerf]:checked');             //Selection de la nouvelle performance

            //Choix de la longueur totale du demi gabarit selon la performance
            switch (clickedPerf.attr('value')) {
                case '1':
                    longueurTotale = 3378;
                    break;
                case '2':
                    longueurTotale = 1216;
                    break;
                case '3':
                    longueurTotale = 1075;
                    break;
            }
            //Calcul du nouveau gabarit avec les nouvelles données
            getGabarit(startPushpin.getLocation().latitude, startPushpin.getLocation().longitude, coteCarre, angle);
        });

        //---------------------------------------------------------------------------------
        //--------------------------- Fin de Configuration ---------------------------------
        //---------------------------------------------------------------------------------


        //---------------------------------------------------------------------------------
        //---------------------------- La jauge -------------------------------------------
        //---------------------------------------------------------------------------------

        //Ajout d'une div et du canvas sur l'input de type texte
        $('input.numAngle').wrap('<div class="numAngle" />').each(function () {
            input = $(this);
            var div = input.parent();

            cercle = $('<canvas class="numAngle" width="200" height="200">Je ne supporte pas les canvas.</canvas>');
            div.append(cercle);
        });
        
        //On récupère le canvas et son contexte
        canvas = cercle[0];
        context = canvas.getContext('2d');

        //Paramètres du cercle
        xCenter = canvas.clientWidth / 2;  
        yCenter = canvas.clientHeight / 2;           

        //Fonction permettant de redessiner le background
        function drawArc(prmX, prmY, prmRayon, prmAngleStart, prmAngleEnd, prmColor) {
            //On dessine le cercle de fond
            context.beginPath(); //On démarre un nouveau tracé.
            context.strokeStyle = prmColor;
            context.lineWidth = 10;
            context.arc(prmX, prmY, prmRayon, prmAngleStart, prmAngleEnd); //On trace la courbe délimitant notre forme
            context.stroke(); //On utilise la méthode fill(); si l'on veut une forme pleine
            context.closePath();
        }

        //Fonction mise à jour du dessin
        function AngleComputer(prmEvent) {
            prmEvent.preventDefault();

            //On calcul les coordonnées de la souris par rapport au centre de la div canvas
            var xMouse = prmEvent.pageX - cercle.offset().left - xCenter;
            var yMouse = prmEvent.pageY - cercle.offset().top - yCenter;

            //Calcul de l'angle
            var currentAngle = Math.atan2(xMouse, -yMouse) / (2 * Math.PI);
            if (currentAngle < 0) {
                currentAngle += 1;
            }

            //On redessine le canvas pour afficher le dessin de fond et le cercle indiquant l'angle
            context.clearRect(0, 0, canvas.clientWidth, canvas.clientHeight);
            drawArc(xCenter, yCenter, rayon, -1 / 2 * Math.PI, 2 * Math.PI, "rgb(255, 255, 255)");
            drawArc(xCenter, yCenter, rayon, -1 / 2 * Math.PI, (-1 / 2 * Math.PI) + (currentAngle * 2 * Math.PI), "rgba(255, 0, 0, 0.5)");

            angle = currentAngle * 360 - 90;
            
            ////Calcul de l'angle arrondi à 10^-2
            //var angleText = (angle + 90).toFixed(2) + "°";
            //$("#angle").html(angleText);

            //Calcul de l'angle arrondi à l'unité
            var angleEntier = (Math.round(angle + 90)) + "°";
            input.val(angleEntier);

            //Tracé de la trainée d'hélicoptère
            getGabarit(startPushpin.getLocation().latitude, startPushpin.getLocation().longitude, coteCarre, angle);
        }

        //On dessine initialement que le cercle de fond
        drawArc(xCenter, yCenter, rayon, -1 / 2 * Math.PI, 2 * Math.PI, "rgb(255, 255, 255)");
        drawArc(xCenter, yCenter, rayon, -1 / 2 * Math.PI, (angle * Math.PI / 180), "rgba(255, 0, 0, 0.5)");

        //On associe l'évèmement permettant l'affichage d'un cercle représentant un angle
        cercle.mousedown(function (prmEventDown) {
            prmEventDown.preventDefault();

            //On lie l'évènement onMouseMove à une fonction réalisant le dessin
            cercle.bind('mousemove', function (prmEventMove) {
                AngleComputer(prmEventMove);
            });
        });

        //On retire l'évènement OnMove du cercle
        cercle.mouseup(function (prmEventUp) {
            prmEventUp.preventDefault();
            cercle.unbind('mousemove');
        });

        //---------------------------------------------------------------------------------
        //------------------------------- Fin de jauge ------------------------------------
        //---------------------------------------------------------------------------------

    } //end function document.ready
); //end document.ready

//------------------- Fin de traitement logique de l'application -----------------------