unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, GLScene, GLObjects, GLMisc, VectorGeometry, VectorTypes,
  GLProjectedTextures, GLNavigator, JPeg, GLTexture, GLWin32Viewer,
  Joystick, StdCtrls, Buttons;
type
  TForm1 = class(TForm)
    GLScene1: TGLScene;
    GLSceneViewer1: TGLSceneViewer;
    GLDummyCube1: TGLDummyCube;
    GLSphere1: TGLSphere;
    GLCamera1: TGLCamera;
    GLMaterialLibrary1: TGLMaterialLibrary;
    GLNavigator1: TGLNavigator;
    GLUserInterface1: TGLUserInterface;
    Joystick1: TJoystick;
    GLLightSource1: TGLLightSource;
    GLPlane1: TGLPlane;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    BitBtn3: TBitBtn;
    BitBtn4: TBitBtn;
    BitBtn5: TBitBtn;
    BitBtn6: TBitBtn;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    GLLightSource2: TGLLightSource;
    GLLightSource3: TGLLightSource;
    GLLightSource4: TGLLightSource;
    procedure GLSceneViewer1MouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure GLSceneViewer1MouseMove(Sender: TObject; Shift: TShiftState;
      X, Y: Integer);
    procedure FormCreate(Sender: TObject);
    function LoadTexture(Matname,Filename : string) : TGLLibMaterial;
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
    procedure BitBtn5Click(Sender: TObject);
    procedure BitBtn6Click(Sender: TObject);

  private
    { Dclarations prives }
  public
    { Dclarations publiques }
    mx, my : Integer;
  end;

var
  Form1: TForm1;
  Initial : Integer;

implementation

{$R *.dfm}
function mediaPath : string;
begin
   Result := ExtractFilePath(Paramstr(0));
end;

function TForm1.LoadTexture(Matname,Filename : string) : TGLLibMaterial;
begin
   Result := GLMaterialLibrary1.AddTextureMaterial(Matname,mediaPath + Filename);
   Result.Material.Texture.Disabled := false;
   Result.Material.Texture.TextureMode := tmDecal;
end;

procedure TForm1.GLSceneViewer1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
   mx:=x; my:=y;
end;

procedure TForm1.GLSceneViewer1MouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
   if Shift<>[] then begin
      GLCamera1.MoveAroundTarget(my-y, mx-x);
      mx:=x; my:=y;
   end;
end;

procedure TForm1.FormCreate(Sender: TObject);
Var I : Integer;
begin
  Initial :=0;
//Moon
     {LoadTexture('Moon','unwrapped moon.jpg').Material.Texture.TextureMode := tmModulate; }
     LoadTexture('Horizon','FondHorizon1.jpg').Material.Texture.TextureMode := tmModulate;
     //-----------------------------------------
     // Assign materials to objects
     //-----------------------------------------
     GLSphere1.Material.LibMaterialName := 'Horizon';

     {LoadTexture('Moon','unwrapped moon.jpg').Material.Texture.TextureMode := tmModulate; }
     LoadTexture('Instrument','Image1.JPG').Material.Texture.TextureMode := tmModulate;
     //-----------------------------------------
     // Assign materials to objects
     //-----------------------------------------
     GLPlane1.Material.LibMaterialName := 'Instrument';

     {GLUserInterface1.MouseLookActive:=true; }
     {For I := 1 to 180 do begin
                             GLSphere1.Turn(-1);
                           end; }
    GLCamera1.MoveAroundTarget(-30,145);
end;


procedure TForm1.BitBtn1Click(Sender: TObject);
begin
    GLSphere1.Turn(-1);
end;

procedure TForm1.BitBtn2Click(Sender: TObject);
begin
 GLSphere1.Turn(+1);
end;

procedure TForm1.BitBtn3Click(Sender: TObject);
begin
  GLSphere1.Roll(+1);
end;

procedure TForm1.BitBtn4Click(Sender: TObject);
begin
   GLSphere1.Roll(-1);
end;

procedure TForm1.BitBtn5Click(Sender: TObject);
begin
  GLSphere1.Pitch(+1);
end;

procedure TForm1.BitBtn6Click(Sender: TObject);
begin
 GLSphere1.Pitch(-1);
end;

end.
