unit UnitHorizon2;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, GLScene, GLObjects, GLMisc, VectorGeometry, VectorTypes,
  GLProjectedTextures, GLNavigator, JPeg, GLTexture, GLWin32Viewer,
  GLCrossPlatform, GLFile3DS, keyboard,
  GLCadencer,  GLGeomObjects, GLSkydome,
  GLVectorFileObjects, GLLensFlare, AsyncTimer, Joystick, StdCtrls, Buttons, , GLLensFlare, AsyncTimer,
  GLBitmapFont, GLHUDObjects, GLProjectedTextures,
  Joystick, StdCtrls, Buttons;

type
  TForm1 = class(TForm)
    GLScene1: TGLScene;
    GLSceneViewer1: TGLSceneViewer;
    GLDummyCube1: TGLDummyCube;
    GLSphere1: TGLSphere;
    GLCamera1: TGLCamera;
    GLMaterialLibrary1: TGLMaterialLibrary;
    GLNavigator1: TGLNavigator;
    GLUserInterface1: TGLUserInterface;
    Joystick1: TJoystick;
    GLLightSource1: TGLLightSource;
    GLPlane1: TGLPlane;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    BitBtn3: TBitBtn;
    BitBtn4: TBitBtn;
    BitBtn5: TBitBtn;
    BitBtn6: TBitBtn;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    GLLightSource2: TGLLightSource;
    GLLightSource3: TGLLightSource;
    GLLightSource4: TGLLightSource;
    GLCadencer1: TGLCadencer;
    AsyncTimer1: TAsyncTimer;
    GLScene2: TGLScene;
    GLSceneViewer2: TGLSceneViewer;
    GLEarthSkyDome1: TGLEarthSkyDome;
    CameraTarget: TGLDummyCube;
    Camera1: TGLCamera;
    Light1: TGLLightSource;
    DmPlane: TGLDummyCube;
    Plane: TGLFreeForm;
    DmHelice: TGLDummyCube;
    Helice: TGLFreeForm;
    GLLensFlare1: TGLLensFlare;
    procedure GLSceneViewer1MouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure GLSceneViewer1MouseMove(Sender: TObject; Shift: TShiftState;
      X, Y: Integer);
    procedure GLSceneViewer2MouseMove(Sender: TObject;
       Shift: TShiftState; X, Y: Integer);
    procedure GLSceneViewer2MouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure FormCreate(Sender: TObject);
    function LoadTexture(Matname,Filename : string) : TGLLibMaterial;
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
    procedure BitBtn5Click(Sender: TObject);
    procedure BitBtn6Click(Sender: TObject);

    procedure AsyncTimer1Timer(Sender: TObject);
    procedure GLCadencer1Progress(Sender: TObject; const deltaTime,newTime: Double);

  private
    { Dclarations prives }
  public
    { Dclarations publiques }
    mx, my : Integer;
  end;

var
  Form1: TForm1;
  Initial : Integer;

implementation

{$R *.dfm}
function mediaPath : string;
begin
   Result := ExtractFilePath(Paramstr(0));
end;

function TForm1.LoadTexture(Matname,Filename : string) : TGLLibMaterial;
begin
   Result := GLMaterialLibrary1.AddTextureMaterial(Matname,mediaPath + Filename);
   Result.Material.Texture.Disabled := false;
   Result.Material.Texture.TextureMode := tmDecal;
end;

procedure TForm1.GLSceneViewer1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
   mx:=x; my:=y;
end;

procedure TForm1.GLSceneViewer1MouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
   if Shift<>[] then begin
      GLCamera1.MoveAroundTarget(my-y, mx-x);
      mx:=x; my:=y;
   end;
end;

procedure TForm1.FormCreate(Sender: TObject);
Var      I : Integer;
    appdir : string;
begin
  Initial :=0;
//Moon
     {LoadTexture('Moon','unwrapped moon.jpg').Material.Texture.TextureMode := tmModulate; }
     LoadTexture('Horizon','FondHorizon1.jpg').Material.Texture.TextureMode := tmModulate;
     //-----------------------------------------
     // Assign materials to objects
     //-----------------------------------------
     GLSphere1.Material.LibMaterialName := 'Horizon';

     {LoadTexture('Moon','unwrapped moon.jpg').Material.Texture.TextureMode := tmModulate; }
     LoadTexture('Instrument','Image1.JPG').Material.Texture.TextureMode := tmModulate;
     //-----------------------------------------
     // Assign materials to objects
     //-----------------------------------------
     GLPlane1.Material.LibMaterialName := 'Instrument';

     {GLUserInterface1.MouseLookActive:=true; }
     {For I := 1 to 180 do begin
                             GLSphere1.Turn(-1);
                           end; }
    GLCamera1.MoveAroundTarget(-30,145);
   // on recupere le repertoire de notre application avion
   appdir := ExtractFilePath(Application.ExeName);
   // on charge les fichiers 3DS
   Plane.LoadFromFile(appdir+'plane.3ds');
   Helice.LoadFromFile(appdir+'helice.3ds');
   Plane.BuildOctree;
   Helice.BuildOctree;
end;

// AFFICHAGE DES FPS ///////////////////////////////////////////////////////////////////////////////
procedure TForm1.AsyncTimer1Timer(Sender: TObject);
begin
  HTFPS.Text := format('FPS : %.0f',[GLSceneViewer1.FramesPerSecond]);
  GLSceneViewer1.ResetPerformanceMonitor;
end;

// ANIMATION/GESTION CLAVIER ///////////////////////////////////////////////////////////////////////
procedure TForm1.GLCadencer1Progress(Sender: TObject; const deltaTime, newTime: Double);
begin
   // on travail uniquement sur le Dummy DmPlane
   with DmPlane do begin
     // mouvement de droite a gauche et animation sur le RollAngle
     if (IsKeyDown(VK_LEFT))  and (MoveLock.Left)  then begin
        {Position.x := Position.x - 0.015;
        if rollangle < 20 then} RollAngle  := RollAngle + 1;
     end else
     if (IsKeyDown(VK_RIGHT)) and (MoveLock.Right) then begin
        {Position.x := Position.x + 0.015;
        if rollangle > -20 then} RollAngle  := RollAngle - 1;
     end else begin
        // on fait revenir l'avion a un angle 0
        if rollangle > 0 then RollAngle  := RollAngle - 1;
        if rollangle < 0 then RollAngle  := RollAngle + 1;
     end;

     // avancer et reculer
     if (IsKeyDown(VK_UP))    and (MoveLock.Up)    then
        {Position.z := Position.z - 0.01;}
        PitchAngle  := PitchAngle +1;
     if (IsKeyDown(VK_DOWN))  and (MoveLock.Down)  then
        Position.z := Position.z + 0.01;

     // gestion du "lockage" de mouvement et animation des fleches de control
     // a gauche
     if Position.x <= -1.2   then begin
        MoveLock.Left  := false;
        leftarrow.ModulateColor.SetColor(1,0,0,0.5);
     end else begin
        MoveLock.Left  := true;
        leftarrow.ModulateColor.SetColor(0,1,0,0.5);
     end;
     // a droite
     if Position.x >= 1.2    then begin
        MoveLock.Right := false;
        rightarrow.ModulateColor.SetColor(1,0,0,0.5);
     end else begin
        MoveLock.Right := true;
        rightarrow.ModulateColor.SetColor(0,1,0,0.5);
     end;
     // en haut
     if Position.z <= -1     then begin
        MoveLock.Up    := false;
        toparrow.ModulateColor.SetColor(1,0,0,0.5);
     end else begin
        MoveLock.Up    := true;
        toparrow.ModulateColor.SetColor(0,1,0,0.5);
     end;
     // en bas
     if Position.z >= 0 then begin
        MoveLock.Down  := false;
        bottomarrow.ModulateColor.SetColor(1,0,0,0.5);
     end else begin
        MoveLock.Down  := true;
        bottomarrow.ModulateColor.SetColor(0,1,0,0.5);
     end;
  end;
  // animation de l'helice de l'avion
  DmHelice.RollAngle := NewTime * 1800;
end;

procedure TForm1.GLSceneViewer2MouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
   if Shift<>[] then begin
      Camera1.MoveAroundTarget(my-y, mx-x);
      mx:=x; my:=y;
   end;
end;

procedure TForm1.GLSceneViewer2MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
   if Shift<>[] then begin
      mx:=x; my:=y;
   end;
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
    GLSphere1.Turn(-1);
end;

procedure TForm1.BitBtn2Click(Sender: TObject);
begin
 GLSphere1.Turn(+1);
end;

procedure TForm1.BitBtn3Click(Sender: TObject);
begin
  GLSphere1.Roll(+1);
end;

procedure TForm1.BitBtn4Click(Sender: TObject);
begin
   GLSphere1.Roll(-1);
end;

procedure TForm1.BitBtn5Click(Sender: TObject);
begin
  GLSphere1.Pitch(+1);
end;

procedure TForm1.BitBtn6Click(Sender: TObject);
begin
 GLSphere1.Pitch(-1);
end;

end.
