unit UnitHorizon3;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, GLScene, GLObjects, GLMisc, VectorGeometry, VectorTypes,
  GLProjectedTextures, GLNavigator, JPeg, GLTexture, GLWin32Viewer,
  GLCrossPlatform, GLFile3DS, keyboard,
  GLCadencer,  GLGeomObjects, GLSkydome,
  GLVectorFileObjects, GLLensFlare, AsyncTimer, Joystick, StdCtrls, Buttons,
  GLBitmapFont, GLHUDObjects, ExtCtrls, ImgList;

type
  // type permettant de controller les deplacements possible
  TMoveLock = record
   Left,Right,Up,Down : boolean;
  end;
  
  TForm1 = class(TForm)
    GLScene1: TGLScene;
    GLSceneViewer1: TGLSceneViewer;
    GLDummyCube1: TGLDummyCube;
    GLSphere1: TGLSphere;
    GLCamera1: TGLCamera;
    GLMaterialLibrary1: TGLMaterialLibrary;
    GLNavigator1: TGLNavigator;
    GLUserInterface1: TGLUserInterface;
    Joystick1: TJoystick;
    GLLightSource1: TGLLightSource;
    GLPlane1: TGLPlane;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    BitBtn3: TBitBtn;
    BitBtn4: TBitBtn;
    BitBtn5: TBitBtn;
    BitBtn6: TBitBtn;
    GLLightSource2: TGLLightSource;
    GLLightSource3: TGLLightSource;
    GLLightSource4: TGLLightSource;
    GLCadencer1: TGLCadencer;
    AsyncTimer1: TAsyncTimer;
    GLScene2: TGLScene;
    GLSceneViewer2: TGLSceneViewer;
    GLEarthSkyDome1: TGLEarthSkyDome;
    CameraTarget: TGLDummyCube;
    Camera1: TGLCamera;
    Light1: TGLLightSource;
    DmPlane: TGLDummyCube;
    Plane: TGLFreeForm;
    DmHelice: TGLDummyCube;
    Helice: TGLFreeForm;
    GLLensFlare1: TGLLensFlare;
    GLCamera2: TGLCamera;
    GLNavigator2: TGLNavigator;
    GLUserInterface2: TGLUserInterface;
    RadioGroup1: TRadioGroup;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Image1: TImage;
    Image2: TImage;
    PaintBox1: TPaintBox;
    Image21: TImage;
    Image39: TImage;
    PaintBox2: TPaintBox;
    PaintBox3: TPaintBox;
    PaintBox4: TPaintBox;
    PaintBox5: TPaintBox;
    PaintBox6: TPaintBox;
    Image3: TImage;
    Label13: TLabel;
    Label14: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    Panel1: TPanel;
    Panel2: TPanel;
    GLSceneViewer3: TGLSceneViewer;
    GLScene3: TGLScene;
    GLLightSource5: TGLLightSource;
    Cube1: TGLCube;
    DummyCube1: TGLDummyCube;
    Cylinder1: TGLCylinder;
    DummyCube2: TGLDummyCube;
    Sphere1: TGLSphere;
    Sphere2: TGLSphere;
    Sphere3: TGLSphere;
    Sphere4: TGLSphere;
    DummyCube3: TGLDummyCube;
    GLCamera3: TGLCamera;
    Image4: TImage;
    Image5: TImage;
    Image6: TImage;
    Image7: TImage;
    Image8: TImage;
    Image9: TImage;
    Image10: TImage;
    Image11: TImage;
    Image12: TImage;
    Image13: TImage;
    Image14: TImage;
    Image15: TImage;
    Image16: TImage;
    Image17: TImage;
    Image18: TImage;
    Image19: TImage;
    BitBtn7: TBitBtn;
    Label15: TLabel;
    Label21: TLabel;
    Label22: TLabel;
    Label23: TLabel;
    Label24: TLabel;


    procedure GLSceneViewer1MouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure GLSceneViewer1MouseMove(Sender: TObject; Shift: TShiftState;
      X, Y: Integer);
    procedure GLSceneViewer2MouseMove(Sender: TObject;
       Shift: TShiftState; X, Y: Integer);
    procedure GLSceneViewer2MouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure FormCreate(Sender: TObject);
    function LoadTexture(Matname,Filename : string) : TGLLibMaterial;
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
    procedure BitBtn5Click(Sender: TObject);
    procedure BitBtn6Click(Sender: TObject);

    procedure AsyncTimer1Timer(Sender: TObject);
    procedure GLCadencer1Progress(Sender: TObject; const deltaTime,newTime: Double);
    procedure Joystick1JoystickMove(Sender: TObject; JoyID: TJoystickID;
      Buttons: TJoystickButtons; XDeflection, YDeflection: Integer);
    procedure BitBtn7Click(Sender: TObject);
    procedure BitBtn8Click(Sender: TObject);

    procedure Joystick1JoystickButtonChange(Sender: TObject;
      JoyID: TJoystickID; Buttons: TJoystickButtons; XDeflection,
      YDeflection: Integer);

    procedure BaisseAileronDroit;
    procedure EffaceBaisseAileronDroit;
    procedure BaisseAileronGauche;
    procedure EffaceBaisseAileronGauche;

    procedure MonteProfondeur;
    procedure BaisseProfondeur;
    procedure EffaceMonteProfondeur;
    procedure EffaceBaisseProfondeur;

    procedure EffaceGouverneGauche;
    procedure EffaceGouverneDroite;
    procedure GouverneGauche;
    procedure GouverneDroite;
    procedure BitBtn2KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure BitBtn2KeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure BitBtn2MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure BitBtn2MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure BitBtn1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure BitBtn1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure BitBtn4MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure BitBtn4MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure BitBtn3MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure BitBtn3MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure BitBtn6MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure BitBtn6MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure BitBtn5MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure BitBtn5MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);

  private
    { Dclarations prives }
  public
    { Dclarations publiques }
    mx, my : Integer;
  end;

var
  Form1: TForm1;
  Initial : Integer;
  MoveLock : TMoveLock = (Left : true; Right : true; Up : true; Down : true);
  Xjoy : Integer;
  Yjoy : Integer;
  XjoyS : String;
  YjoyS : String;
  AD : Integer;
  AG : Integer;
  MP : Integer;
  BP : Integer;
  GD : Integer;
  GG : Integer;
  X, Y, Z : Integer;
  XS,YS,ZS : String;
implementation

{$R *.dfm}
function mediaPath : string;
begin
   Result := ExtractFilePath(Paramstr(0));
end;

function TForm1.LoadTexture(Matname,Filename : string) : TGLLibMaterial;
begin
   Result := GLMaterialLibrary1.AddTextureMaterial(Matname,mediaPath + Filename);
   Result.Material.Texture.Disabled := false;
   Result.Material.Texture.TextureMode := tmDecal;
end;

procedure TForm1.GLSceneViewer1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
   mx:=x; my:=y;
end;

procedure TForm1.GLSceneViewer1MouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
   if Shift<>[] then begin
      GLCamera1.MoveAroundTarget(my-y, mx-x);
      mx:=x; my:=y;
   end;
end;

procedure TForm1.FormCreate(Sender: TObject);
Var      I : Integer;
    appdir : string;
    newTime: Double;
begin
  Initial :=0;
  Image6.Visible := True;
  Image7.Visible := True;
  Image4.Visible := True;
  Image11.Visible := True;
  Image8.Visible := False;
  Image9.Visible := False;
  Image12.Visible := False;
  Image13.Visible := False;
  Image14.Visible := False;
  Image16.Visible := False;
  Image15.Visible := False;
  Image17.Visible := False;
  Image18.Visible := False;
  Image19.Visible := False;
    PaintBox1.Canvas.Brush.Color := clBlack;
    PaintBox1.Canvas.Brush.Style := bsSolid;
    PaintBox1.Canvas.Pen.Mode := pmNotXor;
    PaintBox1.Canvas.Ellipse(50,1,70,25);

     // setup default sphere colors
    Joystick1JoystickButtonChange(Self, Joystick1.JoystickID, [], 0, 0);
    Xjoy := Joystick1.XPosition;
    STR(Xjoy,XjoyS);
    Label6.Caption := XjoyS;
    Yjoy := Joystick1.YPosition;
    STR(Yjoy,YjoyS);
    Label7.Caption := YjoyS;
    X := 0;
    Y := 0;
    Z := 0;
//Moon
     {LoadTexture('Moon','unwrapped moon.jpg').Material.Texture.TextureMode := tmModulate; }
     LoadTexture('Horizon','FondHorizon1.jpg').Material.Texture.TextureMode := tmModulate;
     //-----------------------------------------
     // Assign materials to objects
     //-----------------------------------------
     GLSphere1.Material.LibMaterialName := 'Horizon';

     {LoadTexture('Moon','unwrapped moon.jpg').Material.Texture.TextureMode := tmModulate; }
     LoadTexture('Instrument','Image1.JPG').Material.Texture.TextureMode := tmModulate;
     //-----------------------------------------
     // Assign materials to objects
     //-----------------------------------------
     GLPlane1.Material.LibMaterialName := 'Instrument';

     {GLUserInterface1.MouseLookActive:=true; }
     {For I := 1 to 180 do begin
                             GLSphere1.Turn(-1);
                           end; }
    GLCamera1.MoveAroundTarget(-30,145);
   // on recupere le repertoire de notre application avion
   appdir := ExtractFilePath(Application.ExeName);
   // on charge les fichiers 3DS
   Plane.LoadFromFile(appdir+'plane.3ds');
   Helice.LoadFromFile(appdir+'helice.3ds');
   Plane.BuildOctree;
   Helice.BuildOctree;
   // animation de l'helice de l'avion
  {DmHelice.RollAngle := NewTime * 1800;}
  DmHelice.RollAngle := (+1);
end;

// AFFICHAGE DES FPS ///////////////////////////////////////////////////////////////////////////////
procedure TForm1.AsyncTimer1Timer(Sender: TObject);
begin
  {HTFPS.Text := format('FPS : %.0f',[GLSceneViewer1.FramesPerSecond]);
  GLSceneViewer2.ResetPerformanceMonitor; }
  DmHelice.RollAngle := +1;
end;

// ANIMATION/GESTION CLAVIER ///////////////////////////////////////////////////////////////////////
procedure TForm1.GLCadencer1Progress(Sender: TObject; const deltaTime, newTime: Double);
begin
    DmHelice.RollAngle := NewTime * 1000;
    STR(Joystick1.XPosition,XjoyS);
    Label10.Caption := XjoyS;
    STR(Joystick1.YPosition,YjoyS);
    Label11.Caption := YjoyS;
       // Rotate our 3d stick (=cylinder), a dummycube is used as its rotation axis
   DummyCube1.PitchAngle:=-Joystick1.XPosition/3;
   DummyCube1.RollAngle:=Joystick1.YPosition/3;
If RadioGroup1.ItemIndex =2 Then
      Begin
        Xjoy := Joystick1.XPosition;
        STR(Xjoy,XjoyS);
        Label6.Caption := XjoyS;
        Yjoy := Joystick1.YPosition;
        STR(Yjoy,YjoyS);
        Label7.Caption := YjoyS;
      end
    Else Begin   End;

If RadioGroup1.ItemIndex =1 Then
  Begin
    Image3.Visible := True;
    Image21.Visible := False;
    Image39.Visible := False;
    If AG = 1
      Then Begin    EffaceBaisseAileronGauche;
               AG :=0;
           end
      Else Begin End;
    If AD = 1
      Then Begin    EffaceBaisseAileronDroit;
               AD :=0;
           end
      Else Begin End;
    If BP = 1
      Then Begin    EffaceBaisseProfondeur;
               BP :=0;
           end
      Else Begin End;
    If MP = 1
      Then Begin    EffaceMonteProfondeur;
               MP :=0;
           end
      Else Begin End;

  If  Joystick1.YPosition > (Yjoy +5)
    Then  Begin
            GLSphere1.Pitch(-1);
            Y := Y-1;
            If Y = -360
              Then Begin Y := 0; End
              Else Begin End;
              STR(Y,YS);
              Label19.Caption := YS;
            DmPlane.PitchAngle := DmPlane.PitchAngle - 1;
{            If BP = 1
                Then Begin    EffaceMonteProfondeur;
                              BP :=0;
                     end
                Else Begin End; }
            MP := 1;
            MonteProfondeur;
          end
    Else Begin   End;
    If  Joystick1.YPosition < (Yjoy -5)
         Then Begin
                GLSphere1.Pitch(+1);
            Y := Y+1;
            If Y = 360
              Then Begin Y := 0; End
              Else Begin End;
              STR(Y,YS);
              Label19.Caption := YS;
                DmPlane.PitchAngle := DmPlane.PitchAngle + 1;
                If MP = 1
                    Then Begin    EffaceBaisseProfondeur;
                                  MP :=0;
                         end
                    Else Begin End;
                BP := 1;
                BaisseProfondeur;
              end
         Else Begin  End;

  If  Joystick1.XPosition > (Xjoy +5)
    Then  Begin
            {Roulis}
            GLSphere1.Roll(-1);
            X := X-1;
            If X = -360
              Then Begin X := 0; End
              Else Begin End;
              STR(X,XS);
              Label18.Caption := XS;
            DmPlane.RollAngle  := DmPlane.RollAngle - 1;
            Image3.Visible := False;
            Image21.Visible := True;
            AG:=1;
            BaisseAileronGauche;
          end
    Else Begin    End;
    If  Joystick1.XPosition < (Xjoy - 5)
         Then Begin
                GLSphere1.Roll(+1);
                X := X+1;
                If X = 360
                   Then Begin X := 0; End
                   Else Begin End;
                   STR(X,XS);
                   Label18.Caption := XS;
                DmPlane.RollAngle  := DmPlane.RollAngle + 1;
                Image3.Visible := False;
                Image39.Visible := True;
                AD:=1;
                BaisseAileronDroit;

              end
         Else Begin    End;
  end
Else Begin  end;

{  DmPlane.PitchAngle := DmPlane.PitchAngle + Joystick1.XPosition;
  GLSphere1.PitchAngle := GLSphere1.PitchAngle + Joystick1.XPosition;
  DmPlane.RollAngle  := DmPlane.RollAngle + Joystick1.YPosition;
  GLSphere1.RollAngle := GLSphere1.RollAngle + Joystick1.YPosition; }
end;

procedure TForm1.GLSceneViewer2MouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
   if Shift<>[] then begin
      Camera1.MoveAroundTarget(my-y, mx-x);
      mx:=x; my:=y;
   end;
end;

procedure TForm1.GLSceneViewer2MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
   if Shift<>[] then begin
      mx:=x; my:=y;
   end;
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
    Var newTime: Double;
begin
    GLSphere1.Turn(1);
    DmPlane.Turn(-1);
      // animation de l'helice de l'avion
         NewTime := 1;
  DmHelice.RollAngle := NewTime * 1800;
end;

procedure TForm1.BitBtn2Click(Sender: TObject);
    Var newTime: Double;
begin
 GLSphere1.Turn(-1);
 DmPlane.Turn(1);
   // animation de l'helice de l'avion
      NewTime := 1;
  DmHelice.RollAngle := NewTime * 1800;
end;

procedure TForm1.BitBtn3Click(Sender: TObject);
    Var newTime: Double;
begin
              X := X-1;
            If X = -360
              Then Begin X := 0; End
              Else Begin End;
              STR(X,XS);
              Form1.Label18.Caption := XS;

  GLSphere1.Roll(-1);
  DmPlane.RollAngle  := DmPlane.RollAngle - 1;
    // animation de l'helice de l'avion
       NewTime := 1;
  DmHelice.RollAngle := NewTime * 1800;

end;

procedure TForm1.BitBtn4Click(Sender: TObject);
    Var newTime: Double;
begin
            X := X+1;
            If X = 360
              Then Begin X := 0; End
              Else Begin End;
              STR(X,XS);
              Form1.Label18.Caption := XS;

   GLSphere1.Roll(1);
   DmPlane.RollAngle  := DmPlane.RollAngle + 1;
     // animation de l'helice de l'avion
        NewTime := 1;
  DmHelice.RollAngle := NewTime * 1800;

end;

procedure TForm1.BitBtn5Click(Sender: TObject);
    Var newTime: Double;
begin
  GLSphere1.Pitch(+1);
  DmPlane.PitchAngle := DmPlane.PitchAngle + 1;
    // animation de l'helice de l'avion
       NewTime := 1;
  DmHelice.RollAngle := NewTime * 1800;
end;

procedure TForm1.BitBtn6Click(Sender: TObject);
    Var newTime: Double;
begin
 GLSphere1.Pitch(-1);
 DmPlane.PitchAngle := DmPlane.PitchAngle - 1;
   // animation de l'helice de l'avion
   NewTime := 1;
  DmHelice.RollAngle := NewTime * 1800;
end;

procedure TForm1.Joystick1JoystickMove(Sender: TObject; JoyID: TJoystickID;
  Buttons: TJoystickButtons; XDeflection, YDeflection: Integer);
begin
  {Utilisation du joystick}
  {DmPlane.PitchAngle := DmPlane.PitchAngle + Joystick1.XPosition;
   DmPlane.RollAngle  := DmPlane.RollAngle + Joystick1.YPosition;
   DummyCube1.PitchAngle:=-Joystick1.XPosition/3;
   DummyCube1.RollAngle:=Joystick1.YPosition/3; }

   {  If  Joystick1.XPosition > Xjoy
    Then  Begin
            GLSphere1.Pitch(+1);
            DmPlane.PitchAngle := DmPlane.PitchAngle + 1;
          end
    Else If  Joystick1.XPosition = Xjoy
         Then Begin   end
         Else Begin
                GLSphere1.Pitch(-1);
                DmPlane.PitchAngle := DmPlane.PitchAngle - 1;
              End;

  If  Joystick1.YPosition > Yjoy
    Then  Begin
            GLSphere1.Roll(+1);
            DmPlane.RollAngle  := DmPlane.RollAngle - 1;
          end
    Else If  Joystick1.YPosition = Yjoy
         Then Begin   end
         Else Begin
                GLSphere1.Roll(-1);
                DmPlane.RollAngle  := DmPlane.RollAngle + 1;
              End;

        }
end;

procedure TForm1.BitBtn7Click(Sender: TObject);
begin
  GD := 0;
  GG := 0;
    PaintBox1.Canvas.Brush.Color := clBlack;
    PaintBox1.Canvas.Brush.Style := bsSolid;
    PaintBox1.Canvas.Pen.Mode := pmNotXor;
    PaintBox1.Canvas.Ellipse(50,1,70,25);

end;

procedure TForm1.BitBtn8Click(Sender: TObject);
Var Lignes : Integer;
begin
  For Lignes :=20 to 40  do
    Begin
      PaintBox2.Canvas.Pen.Color := clRed;
      PaintBox2.Canvas.Pen.Mode := pmNotXor;
      PaintBox2.Canvas.MoveTo(1,Lignes);
      PaintBox2.Canvas.LineTo(80,Lignes);
    end;
end;

procedure TForm1.BaisseAileronDroit;
Var Lignes : Integer;
begin
  Image13.Visible := True;
  Image11.Visible := False;
  Image12.Visible := False;
  Image8.Visible := True;
  Image9.Visible := False;
  Image4.Visible := False;

  For Lignes :=20 to 40  do
    Begin
      PaintBox2.Canvas.Pen.Color := clRed;
      PaintBox2.Canvas.Pen.Mode := pmNotXor;
      PaintBox2.Canvas.MoveTo(1,Lignes);
      PaintBox2.Canvas.LineTo(80,Lignes);
    end;
  For Lignes :=1 to 20  do
    Begin
      PaintBox3.Canvas.Pen.Color := clRed;
      PaintBox3.Canvas.Pen.Mode := pmNotXor;
      PaintBox3.Canvas.MoveTo(1,Lignes);
      PaintBox3.Canvas.LineTo(80,Lignes);
    end;

end;

procedure TForm1.EffaceBaisseAileronDroit;
Var Lignes : Integer;
begin
  Image13.Visible := False;
  Image11.Visible := True;
  Image12.Visible := False;
  Image4.Visible := True;
  Image8.Visible := False;
  Image9.Visible := False;

  For Lignes :=20 to 40  do
    Begin
      PaintBox2.Canvas.Pen.Color := clRed;
      PaintBox2.Canvas.Pen.Mode := pmNotXor;
      PaintBox2.Canvas.MoveTo(1,Lignes);
      PaintBox2.Canvas.LineTo(80,Lignes);
    end;
  For Lignes :=1 to 20  do
    Begin
      PaintBox3.Canvas.Pen.Color := clRed;
      PaintBox3.Canvas.Pen.Mode := pmNotXor;
      PaintBox3.Canvas.MoveTo(1,Lignes);
      PaintBox3.Canvas.LineTo(80,Lignes);
    end;
end;

procedure TForm1.BaisseAileronGauche;
Var Lignes : Integer;
begin
  Image4.Visible := False;
  Image8.Visible := False;
  Image9.Visible := True;
  Image12.Visible := True;
  Image11.Visible := False;
  Image13.Visible := False;

  For Lignes :=20 to 40  do
    Begin
      PaintBox3.Canvas.Pen.Color := clRed;
      PaintBox3.Canvas.Pen.Mode := pmNotXor;
      PaintBox3.Canvas.MoveTo(1,Lignes);
      PaintBox3.Canvas.LineTo(80,Lignes);
    end;
  For Lignes :=1 to 20  do
    Begin
      PaintBox2.Canvas.Pen.Color := clRed;
      PaintBox2.Canvas.Pen.Mode := pmNotXor;
      PaintBox2.Canvas.MoveTo(1,Lignes);
      PaintBox2.Canvas.LineTo(80,Lignes);
    end;
end;

procedure TForm1.EffaceBaisseAileronGauche;
Var Lignes : Integer;
begin
  Image4.Visible := True;
  Image8.Visible := False;
  Image9.Visible := False;
  Image11.Visible := True;
  Image13.Visible := False;
  Image12.Visible := False;

  For Lignes :=20 to 40  do
    Begin
      PaintBox3.Canvas.Pen.Color := clRed;
      PaintBox3.Canvas.Pen.Mode := pmNotXor;
      PaintBox3.Canvas.MoveTo(1,Lignes);
      PaintBox3.Canvas.LineTo(80,Lignes);
    end;
  For Lignes :=1 to 20  do
    Begin
      PaintBox2.Canvas.Pen.Color := clRed;
      PaintBox2.Canvas.Pen.Mode := pmNotXor;
      PaintBox2.Canvas.MoveTo(1,Lignes);
      PaintBox2.Canvas.LineTo(80,Lignes);
    end;
end;

procedure TForm1.BaisseProfondeur;
Var Lignes : Integer;
begin
  Image6.Visible := False;
  Image7.Visible := False;
  Image14.Visible := False;
  Image16.Visible := False;
  Image15.Visible := True;
  Image17.Visible := True;

  For Lignes :=20 to 40  do
    Begin
      PaintBox4.Canvas.Pen.Color := clRed;
      PaintBox4.Canvas.Pen.Mode := pmNotXor;
      PaintBox4.Canvas.MoveTo(1,Lignes);
      PaintBox4.Canvas.LineTo(77,Lignes);
    end;
  For Lignes :=20 to 40  do
    Begin
      PaintBox5.Canvas.Pen.Color := clRed;
      PaintBox5.Canvas.Pen.Mode := pmNotXor;
      PaintBox5.Canvas.MoveTo(1,Lignes);
      PaintBox5.Canvas.LineTo(77,Lignes);
    end;
End;

procedure TForm1.EffaceBaisseProfondeur;
Var Lignes : Integer;
begin
  Image6.Visible := True;
  Image7.Visible := True;
  Image14.Visible := False;
  Image16.Visible := False;
  Image15.Visible := False;
  Image17.Visible := False;

  For Lignes :=20 to 40  do
    Begin
      PaintBox4.Canvas.Pen.Color := clRed;
      PaintBox4.Canvas.Pen.Mode := pmNotXor;
      PaintBox4.Canvas.MoveTo(1,Lignes);
      PaintBox4.Canvas.LineTo(77,Lignes);
    end;
  For Lignes :=20 to 40  do
    Begin
      PaintBox5.Canvas.Pen.Color := clRed;
      PaintBox5.Canvas.Pen.Mode := pmNotXor;
      PaintBox5.Canvas.MoveTo(1,Lignes);
      PaintBox5.Canvas.LineTo(77,Lignes);
    end;
End;

procedure TForm1.MonteProfondeur;
Var Lignes : Integer;
begin
  Image6.Visible := False;
  Image7.Visible := False;
  Image14.Visible := True;
  Image16.Visible := True;
  Image15.Visible := False;
  Image17.Visible := False;

  For Lignes :=1 to 20  do
    Begin
      PaintBox4.Canvas.Pen.Color := clRed;
      PaintBox4.Canvas.Pen.Mode := pmNotXor;
      PaintBox4.Canvas.MoveTo(1,Lignes);
      PaintBox4.Canvas.LineTo(77,Lignes);
    end;
  For Lignes :=1 to 20  do
    Begin
      PaintBox5.Canvas.Pen.Color := clRed;
      PaintBox5.Canvas.Pen.Mode := pmNotXor;
      PaintBox5.Canvas.MoveTo(1,Lignes);
      PaintBox5.Canvas.LineTo(77,Lignes);
    end;
End;

procedure TForm1.EffaceMonteProfondeur;
Var Lignes : Integer;
begin
  Image6.Visible := True;
  Image7.Visible := True;
  Image14.Visible := False;
  Image16.Visible := False;
  Image15.Visible := False;
  Image17.Visible := False;

  For Lignes :=1 to 20  do
    Begin
      PaintBox4.Canvas.Pen.Color := clRed;
      PaintBox4.Canvas.Pen.Mode := pmNotXor;
      PaintBox4.Canvas.MoveTo(1,Lignes);
      PaintBox4.Canvas.LineTo(77,Lignes);
    end;
  For Lignes :=1 to 20  do
    Begin
      PaintBox5.Canvas.Pen.Color := clRed;
      PaintBox5.Canvas.Pen.Mode := pmNotXor;
      PaintBox5.Canvas.MoveTo(1,Lignes);
      PaintBox5.Canvas.LineTo(77,Lignes);
    end;
End;

procedure TForm1.GouverneGauche;
Var Lignes : Integer;
begin
  Image18.Visible := True;
  Image19.Visible := False;

    PaintBox1.Canvas.Brush.Color := clBlack;
    PaintBox1.Canvas.Brush.Style := bsSolid;
    PaintBox1.Canvas.Pen.Mode := pmNotXor;
    PaintBox1.Canvas.Ellipse(95,1,115,25);


    PaintBox1.Canvas.Brush.Color := clBlack;
    PaintBox1.Canvas.Brush.Style := bsSolid;
    PaintBox1.Canvas.Pen.Mode := pmNotXor;
    PaintBox1.Canvas.Ellipse(50,1,70,25);

  For Lignes :=1 to 73  do
    Begin
      PaintBox6.Canvas.Pen.Color := clRed;
      PaintBox6.Canvas.Pen.Mode := pmNotXor;
      PaintBox6.Canvas.MoveTo(1,Lignes);
      PaintBox6.Canvas.LineTo(25,Lignes);
    end;
End;

procedure TForm1.GouverneDroite;
Var Lignes : Integer;
begin
    PaintBox1.Canvas.Brush.Color := clBlack;
    PaintBox1.Canvas.Brush.Style := bsSolid;
    PaintBox1.Canvas.Pen.Mode := pmNotXor;
    PaintBox1.Canvas.Ellipse(1,1,20,25);
    PaintBox1.Canvas.Brush.Color := clBlack;
    PaintBox1.Canvas.Brush.Style := bsSolid;
    PaintBox1.Canvas.Pen.Mode := pmNotXor;
    PaintBox1.Canvas.Ellipse(50,1,70,25);

  Image18.Visible := False;
  Image19.Visible := True;

  For Lignes :=1 to 73  do
    Begin
      PaintBox6.Canvas.Pen.Color := clRed;
      PaintBox6.Canvas.Pen.Mode := pmNotXor;
      PaintBox6.Canvas.MoveTo(26,Lignes);
      PaintBox6.Canvas.LineTo(50,Lignes);
    end;
End;

procedure TForm1.EffaceGouverneGauche;
Var Lignes : Integer;
begin
  Image18.Visible := False;
  Image19.Visible := False;
    PaintBox1.Canvas.Brush.Color := clBlack;
    PaintBox1.Canvas.Brush.Style := bsSolid;
    PaintBox1.Canvas.Pen.Mode := pmNotXor;
    PaintBox1.Canvas.Ellipse(95,1,115,25);

    PaintBox1.Canvas.Brush.Color := clBlack;
    PaintBox1.Canvas.Brush.Style := bsSolid;
    PaintBox1.Canvas.Pen.Mode := pmNotXor;
    PaintBox1.Canvas.Ellipse(50,1,70,25);

  For Lignes :=1 to 73  do
    Begin
      PaintBox6.Canvas.Pen.Color := clRed;
      PaintBox6.Canvas.Pen.Mode := pmNotXor;
      PaintBox6.Canvas.MoveTo(1,Lignes);
      PaintBox6.Canvas.LineTo(25,Lignes);
    end;
End;

procedure TForm1.EffaceGouverneDroite;
Var Lignes : Integer;
begin
  Image18.Visible := False;
  Image19.Visible := False;
    PaintBox1.Canvas.Brush.Color := clBlack;
    PaintBox1.Canvas.Brush.Style := bsSolid;
    PaintBox1.Canvas.Pen.Mode := pmNotXor;
    PaintBox1.Canvas.Ellipse(1,1,20,25);
    PaintBox1.Canvas.Brush.Color := clBlack;
    PaintBox1.Canvas.Brush.Style := bsSolid;
    PaintBox1.Canvas.Pen.Mode := pmNotXor;
    PaintBox1.Canvas.Ellipse(50,1,70,25);


  For Lignes :=1 to 73  do
    Begin
      PaintBox6.Canvas.Pen.Color := clRed;
      PaintBox6.Canvas.Pen.Mode := pmNotXor;
      PaintBox6.Canvas.MoveTo(26,Lignes);
      PaintBox6.Canvas.LineTo(50,Lignes);
    end;
End;

procedure TForm1.BitBtn2KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
    GouverneGauche;

end;

procedure TForm1.BitBtn2KeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
    EffaceGouverneGauche;

end;

procedure TForm1.BitBtn2MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
   GouverneDroite;
end;

procedure TForm1.BitBtn2MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  EffaceGouverneDroite;
end;

procedure TForm1.BitBtn1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  GouverneGauche;
end;

procedure TForm1.BitBtn1MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  EffaceGouverneGauche;
end;

procedure TForm1.BitBtn4MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  BaisseAileronDroit;
end;

procedure TForm1.BitBtn4MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  EffaceBaisseAileronDroit;
end;

procedure TForm1.BitBtn3MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  EffaceBaisseAileronGauche;
end;

procedure TForm1.BitBtn3MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  BaisseAileronGauche;
end;

procedure TForm1.BitBtn6MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  EffaceMonteProfondeur;
end;

procedure TForm1.BitBtn6MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  MonteProfondeur;
end;

procedure TForm1.BitBtn5MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  EffaceBaisseProfondeur;
end;

procedure TForm1.BitBtn5MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  BaisseProfondeur;
end;

procedure TForm1.Joystick1JoystickButtonChange(Sender: TObject;
  JoyID: TJoystickID; Buttons: TJoystickButtons; XDeflection,
  YDeflection: Integer);
const
   cPressedColor : array [False..True] of Integer = (clGray, clWhite);
var
   button : TJoystickButton;
   i : Integer;
begin
   // Browse all buttons and adjusts matching spheres color
   // All the spheres are accessed in an arrayed fashion (I made them
   // child of a single dummycube)
   i:=0;
   for button:=jbButton1 to jbButton4 do begin
      with TGLSphere(DummyCube2.Children[i]).Material.FrontProperties.Diffuse do
         AsWinColor:=cPressedColor[button in buttons];
      Inc(i);
   end;
end;

end.
