{
   GLScene exemple 4
   (exemple 4 car le 2 et le 3 etaient des tests foireux ...)
   ( www.glscene.org )

   by Deefaze [f0xi - www.delphifr.com]

   04/12/2005

   Les objets 3DS viennent d'un tuto 3DSMax (fichier MAX), je ne connais pas le modelisateur
   mais je tiens a le remercier pour ce modele lowpolygons d'excelente qualite.
   Merci de ne pas reutiliser ces objets 3DS dans vos projets.
}

{/////////////////////////////////////////////////////////////////////////////////////////////////
 Fichier 3DS :
 Les fichiers 3DS sont chargs dans un FreeForm (Plane et Helice), cela requiere egalement de
 declarer l'unit GLFile3DS dans la close Uses.
 Les objets necessite une mise au point (scale et angle) pour etre parfaitement positionns et
 affichs dans la scene.

 Plane necessite un scale a x0.04, y0.08, z0.08 et un Angle de p90 t-90.
 Pour effectuer tout les mouvements nous agissons sur le Dummy "DmPlane", sur ses proprits
 RollAngle et Position. Nous inclinons l'avion de -20 et +20 quand il vas de gauche a droite.
 L'avion reviens seul a RollAngle = 0 quand nous relacherons les fleches gauche et droite.

 Helice necessite les memes parametres que Plane. pour effectuer les mouvements nous agissons sur
 le DummyCube "DmHelice", sur sa proprit RollAngle.
 le mouvement est obtenus grace a RollAngle = NewTime * 1800 (1800 par passe)
 ///////////////////////////////////////////////////////////////////////////////////////////////// }

unit main;

interface

uses
  {DELPHI}
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms, Menus, Dialogs,
  {USER}
  keyboard, GLCrossPlatform, GLFile3DS, GLTexture, jpeg,
  {GLSCENE}
  GLScene, GLObjects, GLMisc, GLCadencer, GLWin32Viewer, GLGeomObjects, GLSkydome,
  GLVectorFileObjects, VectorGeometry, GLLensFlare, AsyncTimer,
  GLBitmapFont, GLWindowsFont, GLHUDObjects, GLProjectedTextures;

type
  // type permettant de controller les deplacements possible
  TMoveLock = record
   Left,Right,Up,Down : boolean;
  end;

  TForm1 = class(TForm)
    GLScene1             : TGLScene;
    GLSceneViewer1       : TGLSceneViewer;
    GLCadencer1          : TGLCadencer;
    AsyncTimer1          : TAsyncTimer;

    GLEarthSkyDome1      : TGLEarthSkyDome;
    GLLensFlare1         : TGLLensFlare;
    CameraTarget         : TGLDummyCube;
    Camera1              : TGLCamera;
    Light1               : TGLLightSource;

    DmPlane              : TGLDummyCube;
    Plane                : TGLFreeForm;
    DmHelice             : TGLDummyCube;
    Helice               : TGLFreeForm;

    SceneTexts           : TGLDummyCube;
    GLWindowsBitmapFont1 : TGLWindowsBitmapFont;
    HTFPS                : TGLHUDText;
    HTKeyHelp            : TGLHUDText;

    NavigationArrow      : TGLDummyCube;
    GLWindowsBitmapFont2 : TGLWindowsBitmapFont;
    TopArrow             : TGLHUDText;
    BottomArrow          : TGLHUDText;
    LeftArrow            : TGLHUDText;
    RightArrow           : TGLHUDText;

    MainMenu1            : TMainMenu;
    GLScene2             : TMenuItem;
    Quitter1             : TMenuItem;
    Scene1               : TMenuItem;
    Voirlesdummycubes1   : TMenuItem;
    Voirlesaxes1         : TMenuItem;
    Afficherlestouches1  : TMenuItem;

    procedure FormCreate(Sender: TObject);
    procedure AsyncTimer1Timer(Sender: TObject);
    procedure GLCadencer1Progress(Sender: TObject; const deltaTime,newTime: Double);
    procedure Quitter1Click(Sender: TObject);
    procedure Voirlesdummycubes1Click(Sender: TObject);
    procedure Voirlesaxes1Click(Sender: TObject);
    procedure Afficherlestouches1Click(Sender: TObject);
    procedure GLSceneViewer1MouseMove(Sender: TObject; Shift: TShiftState;
      X, Y: Integer);
    procedure GLSceneViewer1MouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
      mx, my: Integer;

  end;

var
  Form1: TForm1;
  // notre constante permettant de "locker" les deplacements.
  // on peu initialis une variable globale directement. Merci a Cirec pour l'astuce
  // Florenth serat content!!!
  MoveLock : TMoveLock = (Left : true; Right : true; Up : true; Down : true);

implementation

{$R *.dfm}

// INIT ////////////////////////////////////////////////////////////////////////////////////////////
procedure TForm1.FormCreate(Sender: TObject);
var appdir : string;
begin
   // on recupere le repertoire de notre application
   appdir := ExtractFilePath(Application.ExeName);

   // on charge les fichiers 3DS
   Plane.LoadFromFile(appdir+'plane.3ds');
   Helice.LoadFromFile(appdir+'helice.3ds');
   Plane.BuildOctree;
   Helice.BuildOctree;
end;

// AFFICHAGE DES FPS ///////////////////////////////////////////////////////////////////////////////
procedure TForm1.AsyncTimer1Timer(Sender: TObject);
begin
  HTFPS.Text := format('FPS : %.0f',[GLSceneViewer1.FramesPerSecond]);
  GLSceneViewer1.ResetPerformanceMonitor;
end;

// ANIMATION/GESTION CLAVIER ///////////////////////////////////////////////////////////////////////
procedure TForm1.GLCadencer1Progress(Sender: TObject; const deltaTime, newTime: Double);
begin
   // on travail uniquement sur le Dummy DmPlane
   with DmPlane do begin
     // mouvement de droite a gauche et animation sur le RollAngle
     if (IsKeyDown(VK_LEFT))  and (MoveLock.Left)  then begin
        {Position.x := Position.x - 0.015;
        if rollangle < 20 then} RollAngle  := RollAngle + 1;
     end else
     if (IsKeyDown(VK_RIGHT)) and (MoveLock.Right) then begin
        {Position.x := Position.x + 0.015;
        if rollangle > -20 then} RollAngle  := RollAngle - 1;
     end else begin
        // on fait revenir l'avion a un angle 0
        if rollangle > 0 then RollAngle  := RollAngle - 1;
        if rollangle < 0 then RollAngle  := RollAngle + 1;
     end;

     // avancer et reculer
     if (IsKeyDown(VK_UP))    and (MoveLock.Up)    then
        {Position.z := Position.z - 0.01;}
        PitchAngle  := PitchAngle +1;
     if (IsKeyDown(VK_DOWN))  and (MoveLock.Down)  then
        Position.z := Position.z + 0.01;

     // gestion du "lockage" de mouvement et animation des fleches de control
     // a gauche
     if Position.x <= -1.2   then begin
        MoveLock.Left  := false;
        leftarrow.ModulateColor.SetColor(1,0,0,0.5);
     end else begin
        MoveLock.Left  := true;
        leftarrow.ModulateColor.SetColor(0,1,0,0.5);
     end;
     // a droite
     if Position.x >= 1.2    then begin
        MoveLock.Right := false;
        rightarrow.ModulateColor.SetColor(1,0,0,0.5);
     end else begin
        MoveLock.Right := true;
        rightarrow.ModulateColor.SetColor(0,1,0,0.5);
     end;
     // en haut
     if Position.z <= -1     then begin
        MoveLock.Up    := false;
        toparrow.ModulateColor.SetColor(1,0,0,0.5);
     end else begin
        MoveLock.Up    := true;
        toparrow.ModulateColor.SetColor(0,1,0,0.5);
     end;
     // en bas
     if Position.z >= 0 then begin
        MoveLock.Down  := false;
        bottomarrow.ModulateColor.SetColor(1,0,0,0.5);
     end else begin
        MoveLock.Down  := true;
        bottomarrow.ModulateColor.SetColor(0,1,0,0.5);
     end;
  end;
  // animation de l'helice de l'avion
  DmHelice.RollAngle := NewTime * 1800;
end;

// MENU QUITTER ////////////////////////////////////////////////////////////////////////////////////
procedure TForm1.Quitter1Click(Sender: TObject);
begin
  form1.Close;
end;

// MENU Voir les DummyCubes ////////////////////////////////////////////////////////////////////////
procedure TForm1.Voirlesdummycubes1Click(Sender: TObject);
begin
  with voirlesdummycubes1 do begin
       DmPlane.VisibleAtRunTime := checked;
       DmHelice.VisibleAtRunTime:= checked;
  end;
end;

// MENU Voir les Axes //////////////////////////////////////////////////////////////////////////////
procedure TForm1.Voirlesaxes1Click(Sender: TObject);
begin
  with voirlesaxes1 do begin
       DmPlane.ShowAxes := checked;
  end;
end;

// MENU Afficher les touches ///////////////////////////////////////////////////////////////////////
procedure TForm1.Afficherlestouches1Click(Sender: TObject);
begin
  with afficherlestouches1 do begin
    HTKeyHelp.Visible := checked;
  end;
end;

procedure TForm1.GLSceneViewer1MouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
   if Shift<>[] then begin
      Camera1.MoveAroundTarget(my-y, mx-x);
      mx:=x; my:=y;
   end;
end;

procedure TForm1.GLSceneViewer1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
   if Shift<>[] then begin
      mx:=x; my:=y;
   end;
end;

end.
