{: Basic demo for the TGLHeightField and TGLXYZGrid objects.<p>

   HeightFields are used to materialize z=f(x, y) surfaces, you can use it to
   render anything from math formulas to statistics. Most important properties
   of an height field are its sampling scales (X & Y) that determine the extents
   and the resolution of the base grid.<p>

   The component will then invoke it OnGetHeight event to retrieve Z values for
   all of the grid points (values are retrieved only once for each point). Each
   point may have an additionnal color and texture coordinate.<p>

   Three XYZ grids are used to materialize planes, and have been colored to match
   the axis colors. Two controls have been provided to move the XY grid (blue)
   up or down, and center or bound-align the XZ and YZ grids.<p>

   The heightfield component takes care of all the tessellation, so there is not
   much in the code of the unit. Check the advanced "heightfield" sample for
   more dynamic uses.
}
unit Unit11;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, StdCtrls,
  ComCtrls, GLObjects, GLGraph, GLScene, GLMisc, VectorGeometry, VectorTypes,
  GLWin32Viewer, GLProjectedTextures, GLNavigator, JPeg, GLTexture, Buttons,
  Spin;

type
  TForm1 = class(TForm)
    GLScene1: TGLScene;
    GLSceneViewer1: TGLSceneViewer;
    GLCamera1: TGLCamera;
    GLLightSource1: TGLLightSource;
    YZGrid: TGLXYZGrid;
    XZGrid: TGLXYZGrid;
    XYGrid: TGLXYZGrid;
    CBCentered: TCheckBox;
    TBXYPosition: TTrackBar;
    Label1: TLabel;
    GLSphere1: TGLSphere;
    GLProjectedTextures1: TGLProjectedTextures;
    GLHeightField1: TGLHeightField;
    GLMaterialLibrary1: TGLMaterialLibrary;
    GLUserInterface1: TGLUserInterface;
    GLNavigator1: TGLNavigator;
    TrackBar1: TTrackBar;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    Edit1: TEdit;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    SpinEdit1: TSpinEdit;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    GroupBox3: TGroupBox;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    SpinEdit2: TSpinEdit;
    Label10: TLabel;
    GroupBox4: TGroupBox;
    RadioButton3: TRadioButton;
    RadioButton4: TRadioButton;
    SpinEdit3: TSpinEdit;
    GroupBox5: TGroupBox;
    BitBtn3: TBitBtn;
    BitBtn4: TBitBtn;
    BitBtn5: TBitBtn;
    procedure GLSceneViewer1MouseDown(Sender: TObject;
      Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure GLSceneViewer1MouseMove(Sender: TObject; Shift: TShiftState;
      X, Y: Integer);
    procedure CBCenteredClick(Sender: TObject);
    procedure TBXYPositionChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    function LoadTexture(Matname,Filename : string) : TGLLibMaterial;
    procedure TrackBar1Change(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
    procedure SpinEdit2Change(Sender: TObject);
    procedure SpinEdit3Change(Sender: TObject);
    procedure RadioButton3Click(Sender: TObject);
    procedure BitBtn5Click(Sender: TObject);
   { procedure HeightField1GetHeight(const x, y: Single; var z: Single; 
      var color: TVector4f; var texPoint: TTexPoint); }
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
    mx, my : Integer;
  end;

var
  Form1: TForm1;
  Longitude : String;
  Long : Integer;
  Longitude2 : String;
  Long2 : Integer;
  Initial : Integer;
implementation

{$R *.DFM}
function mediaPath : string;
begin
   Result := ExtractFilePath(Paramstr(0));
end;

function TForm1.LoadTexture(Matname,Filename : string) : TGLLibMaterial;
begin
   Result := GLMaterialLibrary1.AddTextureMaterial(Matname,mediaPath + Filename);
   Result.Material.Texture.Disabled := false;
   Result.Material.Texture.TextureMode := tmDecal;
end;
{procedure TForm1.HeightField1GetHeight(const x, y: Single; var z: Single;
  var color: TVector4f; var texPoint: TTexPoint);
begin
   z:=VectorNorm(x, y);
   z:=cos(z*6)/(2*(z*6.28+1));
end; }

procedure TForm1.CBCenteredClick(Sender: TObject);
begin
   if CBCentered.Checked then begin
      XZGrid.YSamplingScale.Origin:=0;
      YZGrid.XSamplingScale.Origin:=0;
   end else begin
      XZGrid.YSamplingScale.Origin:=-1;
      YZGrid.XSamplingScale.Origin:=-1;
   end;
end;

procedure TForm1.TBXYPositionChange(Sender: TObject);
begin
   XZGrid.YSamplingScale.Origin:=-(TBXYPosition.Position/10);
end;

// following code takes care of camera movement, see camera & movement demos
// for explanations and more samples

procedure TForm1.GLSceneViewer1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
   mx:=x; my:=y;
end;

procedure TForm1.GLSceneViewer1MouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
   if Shift<>[] then begin
      GLCamera1.MoveAroundTarget(my-y, mx-x);
      mx:=x; my:=y;
   end;
end;

procedure TForm1.FormCreate(Sender: TObject);
Var I : Integer;
begin
  Initial :=0;
//Moon
     {LoadTexture('Moon','unwrapped moon.jpg').Material.Texture.TextureMode := tmModulate; }
     LoadTexture('Terre','Terre.jpg').Material.Texture.TextureMode := tmModulate;
     //-----------------------------------------
     // Assign materials to objects
     //-----------------------------------------
     GLSphere1.Material.LibMaterialName := 'Terre';
     {GLUserInterface1.MouseLookActive:=true; }
     For I := 1 to 180 do begin
                             GLSphere1.Turn(-1);
                           end;
     Long := 0;
     Longitude := '0';
     Edit1.Text := Longitude;
end;

procedure TForm1.TrackBar1Change(Sender: TObject);
begin
YZGrid.XSamplingScale.Origin:= (TrackBar1.Position/10);
end;

procedure TForm1.BitBtn2Click(Sender: TObject);
begin
  {Longitude Est}
Long := Long + 5;
If Abs(Long) > 180
  then Begin
         Long := 180;
  end
  Else Begin
         GLSphere1.Turn(5);
       end;
STR(Long:0,Longitude);
Edit1.Text := Longitude;
If Long > 0
Then Begin
       Long2 := Long;
       STR(Long2:0,Longitude2);
       Label3.Caption := Longitude2;
       Label2.Caption := '';
     end
Else Begin
     End;
If Long < 0
Then Begin
       Long2 := Abs(Long);
       STR(Long2:0,Longitude2);
       Label2.Caption := Longitude2;
       Label3.Caption := '';
     end
Else Begin
     End;
If Long = 0
Then Begin
       Label2.Caption := '0';
       Label3.Caption := '0';
     end
Else Begin
     End;
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
{Longitude Ouest}
Long := Long - 5;
If Abs(Long) > 180
  then Begin
         Long := -180;
  end
  Else Begin
         GLSphere1.Turn(-5);
       end;
STR(Long:0,Longitude);
Edit1.Text := Longitude;
If Long > 0
Then Begin
       Long2 := Long;
       STR(Long2:0,Longitude2);
       Label3.Caption := Longitude2;
       Label2.Caption := '';
     end
Else Begin
       {Label2.Caption := ''; }
     End;
If Long < 0
Then Begin
       Long2 := Abs(Long);
       STR(Long2:0,Longitude2);
       Label2.Caption := Longitude2;
       Label3.Caption := '';
     end
Else Begin
       {Label3.Caption := '';}
     End;
     If Long = 0
Then Begin
       Label2.Caption := '0';
       Label3.Caption := '0';
     end
Else Begin
     End;
end;

procedure TForm1.BitBtn3Click(Sender: TObject);
begin
LoadTexture('Terre','Terre.jpg').Material.Texture.TextureMode := tmModulate;
GLSphere1.Material.LibMaterialName := 'Terre';
end;

procedure TForm1.BitBtn4Click(Sender: TObject);
begin
LoadTexture('Terre2','Terre2.jpg').Material.Texture.TextureMode := tmModulate;
GLSphere1.Material.LibMaterialName := 'Terre2';
end;

procedure TForm1.SpinEdit2Change(Sender: TObject);
Var    Y : Real;
      YS : String;
begin
  {Modification de la latitude}
  If RadioButton1.Checked = True
     Then Begin  {Nord}
  Y := sin(SpinEdit2.Value* (Pi/180));
  STR(Y:0,YS);
  Label8.Caption := YS;
  XZGrid.YSamplingScale.Origin:=(Y);
          end
     Else Begin   {Sud}
  Y := sin(SpinEdit2.Value* (Pi/180));
  STR(Y:0,YS);
  Label8.Caption := YS;
  XZGrid.YSamplingScale.Origin:=-(Y);
          End;

end;

procedure TForm1.SpinEdit3Change(Sender: TObject);
begin
  {Modification de la longitude}
  If RadioButton3.Checked = True
     Then Begin  {Ouest}
            If SpinEdit3.Value > Initial
               Then Begin
                      GLSphere1.Turn(-1);
                      Initial := SpinEdit3.Value;
   If SpinEdit3.Value <> 0
     Then Begin
            RadioButton3.Enabled := False;
            RadioButton4.Enabled := False;
          end
     Else Begin
            RadioButton3.Enabled := True;
            RadioButton4.Enabled := True;
          End;
                    end
               Else Begin
                      GLSphere1.Turn(1);
                      Initial := SpinEdit3.Value;
   If SpinEdit3.Value <> 0
     Then Begin
            RadioButton3.Enabled := False;
            RadioButton4.Enabled := False;
          end
     Else Begin
            RadioButton3.Enabled := True;
            RadioButton4.Enabled := True;
          End;
                    End;
          end
     Else Begin  {Est}
            If SpinEdit3.Value > Initial
               Then Begin
                      GLSphere1.Turn(1);
                      Initial := SpinEdit3.Value;
   If SpinEdit3.Value <> 0
     Then Begin
            RadioButton3.Enabled := False;
            RadioButton4.Enabled := False;
          end
     Else Begin
            RadioButton3.Enabled := True;
            RadioButton4.Enabled := True;
          End;
                    end
               Else Begin
                      GLSphere1.Turn(-1);
                      Initial := SpinEdit3.Value;
   If SpinEdit3.Value <> 0
     Then Begin
            RadioButton3.Enabled := False;
            RadioButton4.Enabled := False;
          end
     Else Begin
            RadioButton3.Enabled := True;
            RadioButton4.Enabled := True;
          End;
                    End;
          End;

end;

procedure TForm1.RadioButton3Click(Sender: TObject);
begin
  {Empecher la rotation si SpinEdit3 different de zero}
  If SpinEdit3.Value <> 0
     Then Begin

          end
     Else Begin

          End;
end;

procedure TForm1.BitBtn5Click(Sender: TObject);
begin
LoadTexture('Terre3','Terre3.jpg').Material.Texture.TextureMode := tmModulate;
GLSphere1.Material.LibMaterialName := 'Terre3';
end;

end.
